<?php
/**
 * Validation Helper Utility
 * Common validation functions
 */
class ValidationHelper {
    
    /**
     * Validate email format
     */
    public static function isValidEmail($email) {
        return filter_var($email, FILTER_VALIDATE_EMAIL) !== false;
    }
    
    /**
     * Validate phone number format
     */
    public static function isValidPhone($phone) {
        // Remove all non-digit characters for validation
        $cleanPhone = preg_replace('/[^0-9]/', '', $phone);
        
        // Check if it's a valid length (7-15 digits)
        return strlen($cleanPhone) >= 7 && strlen($cleanPhone) <= 15;
    }
    
    /**
     * Sanitize string input
     */
    public static function sanitizeString($input) {
        return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
    }
    
    /**
     * Validate required field
     */
    public static function isRequired($value) {
        return !empty(trim($value));
    }
    
    /**
     * Validate string length
     */
    public static function validateLength($value, $min = 0, $max = null) {
        $length = strlen($value);
        
        if ($length < $min) {
            return false;
        }
        
        if ($max !== null && $length > $max) {
            return false;
        }
        
        return true;
    }
    
    /**
     * Validate enum value
     */
    public static function isValidEnum($value, $allowedValues) {
        return in_array($value, $allowedValues, true);
    }
}